<?php
include 'conexao.php';
header('Content-Type: application/json');

$aluno_id = $_GET['aluno_id'] ?? null;
$resultados = [];

if ($aluno_id) {
    // Consulta principal: dados do aluno (a) + matrícula (m) + turma (t)
    $sql = "
        SELECT 
            a.id,
            a.nome,
            a.idade,
            a.genero,
            a.data_nascimento,
            a.contacto,           -- <<< ADICIONADO
            a.endereco,           -- <<< ADICIONADO
            a.opcao_lingua,       -- <<< ADICIONADO
            a.vez,                -- <<< ADICIONADO
            a.observacoes,        -- <<< CORRIGIDO NOME DA COLUNA para 'observacoes'
            a.naturalidade,       -- <<< ADICIONADO
            a.provincia,          -- <<< ADICIONADO
            a.bi_numero,          -- <<< ADICIONADO
            a.bi_emitido_em,      -- <<< ADICIONADO
            a.bi_data_emissao,    -- <<< ADICIONADO
            a.municipio,          -- <<< ADICIONADO
            a.nome_pai,           -- <<< ADICIONADO
            a.nome_mae,           -- <<< ADICIONADO
            a.numero_processo,    -- <<< JÁ EXISTENTE
            a.foto,               -- <<< JÁ EXISTENTE
            
            -- Dados de Turma/Matrícula
            m.turma_id AS turma_id_matricula,
            t.id AS turma_id,
            t.nome AS nome_turma, 
            t.classe,             -- Turma
            t.curso,              -- Turma
            t.turno               -- Turma

        FROM alunos a
        LEFT JOIN matriculas m ON m.aluno_id = a.id
        LEFT JOIN turmas t ON t.id = m.turma_id
        WHERE a.id = ?
        ORDER BY m.ano_letivo DESC, m.id DESC
        LIMIT 1
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $aluno_id);

    if ($stmt->execute()) {
        $result = $stmt->get_result();

        if ($row = $result->fetch_assoc()) {

            // ⚠️ Mapeamento de campos no front-end:
            // O frontend espera o nome da coluna no banco, a menos que haja um conflito.
            // Para simplificar o JS, vamos mapear o que o `editar_aluno.php` espera:

            // 1. Dados da Turma (Exibição no info-box)
            // Prioridade: Tabela Turmas (t). Caso contrário, tenta o campo de texto do Aluno.
            $row['classe'] = $row['classe'] ?: ''; // O JS usa 'classe'
            $row['curso'] = $row['curso'] ?: '';   // O JS usa 'curso'
            $row['turno'] = $row['turno'] ?: '';   // O JS usa 'turno'
            $row['nome_turma_display'] = $row['nome_turma'] ?: ''; // O JS usa 'nome_turma_display'

            // 2. Data de Nascimento (Formato YYYY-MM-DD para input type="date")
            if (!empty($row['data_nascimento'])) {
                $row['data_nascimento'] = date('Y-m-d', strtotime($row['data_nascimento']));
            } else {
                $row['data_nascimento'] = '';
            }
            
            // 3. Observações (O JS espera 'observacoes' ou 'observacao', garantindo que o valor seja enviado)
            // Se a coluna for chamada 'observacao' no BD, renomeie aqui. Corrigido para a.observacoes na query.
            $row['observacoes'] = $row['observacoes'] ?: '';
            
            $resultados[] = $row;
        }
    }

    $stmt->close();
}

$conn->close();
echo json_encode($resultados, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
?>